<?php
header('Content-Type: text/plain; charset=utf-8');
include "../serive/samparka.php";
$config = require __DIR__ . '/novapayconfig.php';

$DEBUG_MODE = true;
function logDebug($msg) {
    global $DEBUG_MODE;
    if ($DEBUG_MODE) {
        file_put_contents('deposit_log.txt', date('[Y-m-d H:i:s] ') . $msg . "\n", FILE_APPEND);
    }
}

// Default “illegal” response
$res = ['code' => 405, 'message' => 'Illegal access!'];

// 1) Gather & sanitize inputs
$uid    = isset($_GET['uid'])    ? intval($_GET['uid']) : null;
$ramt   = isset($_GET['amount'])
            ? mysqli_real_escape_string($conn, $_GET['amount'])
            : '0';
$ramt = htmlspecialchars($ramt);
// force two-decimal format
if (strpos($ramt, '.') === false) {
    $ramt .= '.00';
} else {
    list($int, $dec) = explode('.', $ramt, 2);
    $dec = str_pad(substr($dec, 0, 2), 2, '0');
    $ramt = "$int.$dec";
}

$payName   = 'NovaPay';
$date      = date('Ymd');
$time_sec  = time();
$serial    = $date . $time_sec . rand(100000, 999900);
$createdate = date('Y-m-d H:i:s');
$emailQ     = mysqli_query($conn, "SELECT mobile FROM shonu_subjects WHERE id = '$uid'");
$emailA     = mysqli_fetch_array($emailQ, MYSQLI_ASSOC);
$userm      = $emailA['mobile'];
// 2) Demo‑table bypass
$demoQ = "SELECT 1 FROM demo WHERE balakedara = '$uid'";
if ($conn->query($demoQ)->num_rows > 0) {

    // Insert & immediately credit
    $ins = "
      INSERT INTO thevani
        (payid, balakedara, motta, dharavahi, mula, ullekha, duravani,
         ekikrtapavati, dinankavannuracisi, madari, pavatiaidi, sthiti)
      VALUES
        ('2', '$uid', '$ramt', '$serial', '$payName', 'N/A', '$userm',
         'N/A', '$createdate', '1005', '2', '1')
    ";
    $conn->query($ins);
    $conn->query("UPDATE shonu_kaichila
                  SET motta = ROUND(motta + $ramt, 2)
                  WHERE balakedara = '$uid'");

    header('Location: https://jannatclub.in/#/main');
    exit;
}

// 3) Real‑flow → NovaPay /api/deposit
if (isset($_GET['tyid'], $_GET['amount'], $_GET['uid'], $_GET['sign'], $_GET['urlInfo'])) {
    // Build NovaPay payload
    $payload = [
        'merchantId'  => $config['merchantId'],
        'merchantKey' => $config['merchantKey'],
        'orderId'     => 'PAYIN' . $time_sec,
        'amount'      => $ramt,
        'callbackUrl' => 'https://jannatclub.in/pay/novapaywebhook.php',
        'name'        => "SwadeshiGames",
        'phone'       => "+911234567890",
        'email'       => "admin@jannatclub.in"
    ];

    // Signature per NovaPay spec (filter, sort, http_build_query, append &secret, MD5→UPPER)
    // PHP 8+:
    // $tmp = array_filter($payload, fn($v) => $v !== null && $v !== '');
    // PHP 7+:
    $tmp = array_filter($payload, function($v) {
        return $v !== null && $v !== '';
    });
    unset($tmp['sign']);
    ksort($tmp);
    $qs = http_build_query($tmp) . '&secret=' . $config['merchantKey'];
    $payload['sign'] = strtoupper(md5($qs));

    logDebug("NovaPay deposit payload: " . json_encode($payload));

    // cURL to NovaPay
    $ch = curl_init(rtrim($config['api_url'], '/') . '/api/deposit');
    // force IPv4 DNS resolution
    if (defined('CURLOPT_IPRESOLVE') && defined('CURL_IPRESOLVE_V4')) {
        curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
    }
    curl_setopt_array($ch, [
        CURLOPT_POST           => true,
        CURLOPT_POSTFIELDS     => json_encode($payload),
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER     => ['Content-Type: application/json;charset=UTF-8'],
    ]);
    $resp = curl_exec($ch);
    if (curl_errno($ch)) {
        logDebug("Curl error: " . curl_error($ch));
        echo "Error: payment gateway unreachable";
        exit;
    }
    curl_close($ch);

    $data = json_decode($resp, true);
    if (isset($data['data']['pay_url'])) {
        // record the order for later webhook
        $pay_url    = $data['data']['pay_url'];

        $ins2 = "
          INSERT INTO thevani
            (payid, balakedara, motta, dharavahi, mula, ullekha,
             duravani, ekikrtapavati, dinankavannuracisi, madari,
             pavatiaidi, sthiti)
          VALUES
            ('2', '$uid', '$ramt', '$serial', '$payName',
             '{$data['data']['order_id']}', '$userm', 'N/A', 
             '$createdate', '1005', '2', '0')
        ";
        $conn->query($ins2);

        header('Location: ' . $pay_url);
        exit;
    }

    logDebug("NovaPay error response: " . $resp);
    echo "Error: unable to process payment: " . var_dump($resp);
    exit;
}

// 4) Fallback “illegal”
header('Content-Type: application/json; charset=utf-8');
echo json_encode($res);
exit;
